' Klasa odpowiedzialna za zarzdzanie list dwukierunkow zawierajc egzemplarze interfejsu IDoubleLink.
Public Class DoublyLinkedList
    Private myFirstNode As IDoubleLink
    Private myLastNode As IDoubleLink

    ' Pierwszy wze danej listy dwukierunkowej.
    Public ReadOnly Property FirstNode() As IDoubleLink
        Get
            Return myFirstNode
        End Get
    End Property

    ' Ostatni wze danej listy dwukierunkowej.
    Public ReadOnly Property LastNode() As IDoubleLink
        Get
            Return myLastNode
        End Get
    End Property

    ' Wstawia egzemplarz interfejsu IDoubleLink na pocztek danej listy dwukierunkowej.
    Public Sub AddFirst(ByVal node As IDoubleLink)
        If myFirstNode Is Nothing Then
            myLastNode = node
        Else
            myFirstNode.PrevNode = node
            node.NextNode = myFirstNode
        End If
        myFirstNode = node
        node.ListObject = Me
    End Sub

    ' Dodaje egzemplarz interfejsu IDoubleLink na koniec danej listy dwukierunkowej.
    Public Sub AddLast(ByVal node As IDoubleLink)
        If myLastNode Is Nothing Then
            myFirstNode = node
        Else
            myLastNode.NextNode = node
            node.PrevNode = myLastNode
        End If
        myLastNode = node
        node.ListObject = Me
    End Sub

    ' Usuwa pierwszy obiekt z danej listy dwukierunkowej.
    Public Function RemoveFirst() As IDoubleLink
        Dim prevFirstNode As IDoubleLink = myFirstNode

        If myFirstNode IsNot Nothing Then
            If myFirstNode.NextNode Is Nothing Then
                myLastNode = Nothing
            Else
                myFirstNode.NextNode.PrevNode = Nothing
            End If
            myFirstNode.ListObject = Nothing
            myFirstNode = myFirstNode.NextNode
        End If

        Return prevFirstNode
    End Function

    ' Usuwa ostatni obiekt z danej listy dwukierunkowej.
    Public Function RemoveLast() As IDoubleLink
        Dim prevLastNode As IDoubleLink = myLastNode

        If myLastNode IsNot Nothing Then
            If myLastNode.PrevNode Is Nothing Then
                myFirstNode = Nothing
            Else
                myLastNode.PrevNode.NextNode = Nothing
            End If
            myLastNode.ListObject = Nothing
            myLastNode = myLastNode.PrevNode
        End If

        Return prevLastNode
    End Function
End Class

'
' Definiuje waciwoci implementowane przez egzemplarze interfejsu IDoubleLink.
'
Public Interface IDoubleLink
    ' Reprezentuje poprzedni element listy dwukierunkowej, do ktrej naley ten obiekt
    ' lub warto Nothing, jeli ten obiekt jest pierwszym elementem listy.
    Property PrevNode() As IDoubleLink

    ' Reprezentuje kolejny element listy dwukierunkowej, do ktrej naley ten obiekt,
    ' lub warto Nothing, jeli ten obiekt jest ostatnim elementem listy.
    Property NextNode() As IDoubleLink

    ' Dodaje do listy dwukierunkowej (bezporednio za tym obiektem) dany na wejciu
    ' egzemplarz interfejsu IDoubleLink.
    Sub InsertAfter(ByVal newNode As IDoubleLink)

    ' Dodaje do listy dwukierunkowej (bezporednio przed tym obiektem) dany na wejciu
    ' egzemplarz interfejsu IDoubleLink.
    Sub InsertBefore(ByVal newNode As IDoubleLink)

    ' Usuwa ten obiekt z danej listy dwukierunkowej.
    Sub Remove()

    ' Reprezentuje list dwukierunkow (obiekt klasy DoublyLinkedList), do ktrej naley ten obiekt.
    Property ListObject() As DoublyLinkedList
End Interface 'IDoubleLink

' Klasa AbstractDoubleLink implementuje interfejs IDoubleLink.
Public MustInherit Class AbstractDoubleLink
    Implements IDoubleLink

    ' Reprezentuje list dwukierunkow (obiekt klasy DoublyLinkedList), do ktrej naley ten obiekt.
    Private myListObject As DoublyLinkedList

    ' Reprezentuje poprzedni element listy dwukierunkowej, do ktrej naley ten obiekt,
    ' lub warto Nothing, jeli ten obiekt jest pierwszym elementem listy.
    '
    Private myPrevious As IDoubleLink

    ' Reprezentuje kolejny element listy dwukierunkowej, do ktrej naley ten obiekt,
    ' lub warto Nothing, jeli ten obiekt jest ostatnim elementem listy.
    '
    Private myNext As IDoubleLink

    '
    ' Zwraca albo poprzedni element listy dwukierunkowej, do ktrej naley ten obiekt,
    ' albo warto Nothing, jeli ten obiekt jest pierwszym elementem listy.
    '
    Public Property PrevNode() As IDoubleLink Implements IDoubleLink.PrevNode
        Get
            Return myPrevious
        End Get
        Set(ByVal Value As IDoubleLink)
            myPrevious = Value
        End Set
    End Property

    '
    ' Zwraca albo kolejny element listy dwukierunkowej, do ktrej naley ten obiekt,
    ' albo warto Nothing, jeli ten obiekt jest ostatnim elementem listy.
    '
    Public Property NextNode() As IDoubleLink Implements IDoubleLink.NextNode
        Get
            Return myNext
        End Get
        Set(ByVal Value As IDoubleLink)
            myNext = Value
        End Set
    End Property

    ' Dodaje do listy dwukierunkowej (bezporednio za tym obiektem) dany na wejciu
    ' egzemplarz interfejsu IDoubleLink.
    Public Sub InsertAfter(ByVal newNode As IDoubleLink) _
                                Implements IDoubleLink.InsertAfter
        If (Me.NextNode Is Nothing) And (ListObject IsNot Nothing) Then
            ListObject.RemoveLast()
        Else
            newNode.NextNode = Me.NextNode
            newNode.PrevNode = Me
            If Me.NextNode IsNot Nothing Then
                Me.NextNode.PrevNode = newNode
            End If
            Me.NextNode = newNode
        End If
    End Sub

    ' Dodaje do listy dwukierunkowej (bezporednio przed tym obiektem) dany na wejciu
    ' egzemplarz interfejsu IDoubleLink.
    Public Sub InsertBefore(ByVal newNode As IDoubleLink) _
                            Implements IDoubleLink.InsertBefore
        If (Me.PrevNode Is Nothing) And (ListObject IsNot Nothing) Then
            ListObject.RemoveFirst()
        Else
            newNode.PrevNode = Me.PrevNode
            newNode.NextNode = Me
            If Me.PrevNode IsNot Nothing Then
                Me.PrevNode.NextNode = newNode
            End If
            Me.PrevNode = newNode
        End If
    End Sub

    ' Usuwa ten obiekt z danej listy dwukierunkowej.
    Public Sub Remove() Implements IDoubleLink.Remove
        If NextNode IsNot Nothing Then
            NextNode.PrevNode = PrevNode
        End If
        If PrevNode IsNot Nothing Then
            PrevNode.NextNode = NextNode
        End If
    End Sub

    ' Reprezentuje list dwukierunkow (obiekt klasy DoublyLinkedList), do ktrej naley ten obiekt.
    Public Property ListObject() As DoublyLinkedList _
                                Implements IDoubleLink.ListObject
        Get
            Return myListObject
        End Get
        Set(ByVal Value As DoublyLinkedList)
            myListObject = Value
        End Set
    End Property
End Class 'AbstractDoubleLink
